#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>

using namespace __gnu_pbds;


typedef tree<pair<__int128,int>, null_type,
        less<pair<__int128,int>>, rb_tree_tag,
        tree_order_statistics_node_update>
        ordered_set_pair;

const int N = 2e5 + 3;
const int inf = 1e9;
const double EPS = 1e-5;
ll x[N], v[N];

void solve() {
    int n; ll k; cin >> n >> k;
    for (int i = 1; i <= n; i++) {
        cin >> x[i] >> v[i];
        x[i] *= 1e5;
    }

    ordered_set_pair st;

    __int128 l = 0, r = 1e14;
    while (l + 1 < r) {
        __int128 t = (l + r) / 2;
        ll preticanja = 0;
        st.clear();

        for (int i = n; i >= 1; i--) {
            __int128 d = x[i] + t * v[i];
            ll pr = st.order_of_key({d, inf});
            st.insert({d, i});
            preticanja += pr;
        }
        if (preticanja >= k) {
            r = t;
        } else
            l = t;
    }

    double ans = double(r) * EPS;
    cout << fixed << showpoint << setprecision(5) << ans << "\n";
}

int main() {
    ios::sync_with_stdio(false); cin.tie(0);
    solve();
}